/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Boot Object Definition
::   Copyright   :   (C)2002-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
#ifndef __MOTOTRONBOOTOBJ_H
#define __MOTOTRONBOOTOBJ_H

/* --- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include <AtomicTypes.h>

/* --- DEFINES --------------------------------------------------------------------------------------------*/

/* --- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)

typedef struct
{
    uint1   unused:7;
    uint1   bValid:1;           /* TRUE when the boot application should examine the contents of the custom box */
} S_BootCustomFlags;

typedef struct
{
    S_BootCustomFlags u1Flags;
    uint2 u2BootObjVersion;     /* The version of the boot object */
    void* pBootObj;             /* Pointer to the actual boot object */ 
} S_BootCustom;

typedef struct
{
    bool1   bUseInitialProtocol;
    uint1   u1BootProtocol;
    uint1   u1BootAccessLevel;
    uint1   u1BootCityID;
    uint4   u4BootDefaultKeySerialBaudRate;
    uint4   u4BootCurrentSerialBaudRate;
    uint4   u4BootCANBitRate;
} S_MotoTronBootObj_V0;

typedef struct
{
    uint1   uImageIDToExecute;  /* NAND Flash Image stored in the Boot partition that is to execute */
} S_MotoTronBootObj_V1;

typedef struct
{
    uint1   u1Reserved;         /* MotoTronBootObj_V2 requires no data */
} S_MotoTronBootObj_V2;

#if 0 /* This object is valid, but is not currently used by the MPC5xx Family */
/*!
\brief Describes version 3 of the MotoTronBootObj

       The final TXMessageID that shall be used by the underlying KeySuite protocol engine is calculated as follows:
           
       A message ID (say RxID) is extracted from a CAN Frame that met the u32BootRXAcceptMask and u32BootRXMessageID
       reception conditions. From this we get:
       SS = (RxID >> uRXIdShiftRightForSS) & 0xFF
       DD = (RxID >> uRXIdShiftRightForDD) & 0xFF

       A message ID (say TxID) that shall be sent in response to RxID shall be constructed as follows:
       TxID = u32BootTXMessageID | ( ( (SS << uRXIdShiftRightForDD) | (DD << uRXIdShiftRightForSS) ) & u32BootTXRestrictMask )

       This allows the KeySuite engine to be setup to respond to a series of MessageIDs or to restrict right down to
       just a pair of message IDs
*/
typedef struct S_MotoTronBootObj_V3
{
    bool1   bUseInitialProtocol;
    uint1   u8BootProtocol;
    uint1   u8BootAccessLevel;
    S_CANBusParams CANBusParams;    /*!< CAN Bus Parameters (5 bytes) */
    uint1   uAllowConnectOnCANMask; /*!< A Bit mask where each bit (starting from the LSBit) corresponds to a CAN resource.
                                          Set to the value of 0x01 to open only the first bus. */
    uint1   uConnectedCityID;       /*!< The connected city ID */
    uint1   uRXIdShiftRightForSS;   /*!< Shift right the RX MessageID by this many bits and cast to a byte to extract SS */
    uint1   uRXIdShiftRightForDD;   /*!< Shift right the RX MessageID by this many bits and cast to a byte to extract DD */
    uint4   u32BootTXMessageID;     /*!< The Base message ID for TX */
    uint4   u32BootRXMessageID;     /*!< The Base message ID for RX. The acceptance mask may open this up */
    uint4   u32BootRXAcceptMask;    /*!< Apply this acceptance mask */
    uint4   u32BootTXAcceptMask;
} S_MotoTronBootObj_V3;
#define S_MotoTronBootObj_V3_CONSTRUCTOR(bUseInitialProtocol,                               \
                                         u8BootProtocol,                                    \
                                         u8BootAccessLevel,                                 \
                                         u1PresDiv,                                         \
                                         u1PropSeg,                                         \
                                         u1PhaseSeg1,                                       \
                                         u1PhaseSeg2,                                       \
                                         u1RJW,                                             \
                                         uAllowConnectOnCANMask,                            \
                                         uConnectedCityID,                                  \
                                         uRXIdShiftRightForSS,                              \
                                         uRXIdShiftRightForDD,                              \
                                         u32BootTXMessageID,                                \
                                         u32BootRXMessageID,                                \
                                         u32BootRXAcceptMask,                               \
                                         u32BootTXAcceptMask)                               \
            {bUseInitialProtocol,                                                           \
             u8BootProtocol,                                                                \
             u8BootAccessLevel,                                                             \
             S_CANBusParams_CONSTRUCTOR(u1PresDiv,u1PropSeg,u1PhaseSeg1,u1PhaseSeg2,u1RJW), \
             uAllowConnectOnCANMask,                                                        \
             uConnectedCityID,                                                              \
             uRXIdShiftRightForSS,                                                          \
             uRXIdShiftRightForDD,                                                          \
             u32BootTXMessageID,                                                            \
             u32BootRXMessageID,                                                            \
             u32BootRXAcceptMask,                                                           \
             u32BootTXAcceptMask}
#endif /* #if 0 */

#pragma pack()

/* --- FUNCTION PROTOTYPES --------------------------------------------------------------------------------*/

#endif /* __MOTOTRONBOOTOBJ_H */

/*---- END OF FILE ----------------------------------------------------------------------------------------*/


